KMPVVMCM ;ATL/JMF - Collect HL7/HLO counts for the VistA Message Count Monitor ;3/1/2017
 ;;4.0;CAPACITY MANAGEMENT;;3/1/2018;Build 38
 ;
 ;
RUN ; Collect metrics per configured interval and store in ^KMPTMP("KMPV","VMCM","DLY" -- CALLED VIA CACHE TASK MANAGER
 ;
 ;-----------------------------------------------------------------------
 ;  NOTE:  this routine is written to be tasked off daily at prior to 5 minutes past midnight via the Cache Task Manager on each node.
 ;
 ; ^KMPTMP("KMPV","VMCM","DLY"... storage of data for current day
 ; ^KMPTMP("KMPV","VMCM","TRANSMIT",$J)............. temporary storage for daily VMCM data to be transmitted
 ;   Data in "TRANSMIT" node is deleted upon transmission
 ;   Data in "DLY" node:
 ;    "DLY" Data marked with message number upon transmission - deleted upon Acknowledgement of receipt from server.
 ;    IF DATA MORE THAN 7 DAYS OLD SEND ERROR MESSAGE TO CPE GROUP AND DELETE DATA
 ;    IF DATA MORE THAN 1 DAY OLD SEND WARNING MESSAGE TO CPE GROUP AND SEND DATA
 ;    IF DATA 1 DAY OLD SEND DATA
 ;    
 ;-----------------------------------------------------------------------
 ;
 N KMPVARR,KMPVBLK,KMPVCHKH,KMPVDASH,KMPVDATA,KMPVHANG,KMPVH,KMPVHOUR,KMPVHRSEC,KMPVHTIME,KMPVMEM
 N KMPVMET,KMPVMETS,KMPVMIN,KMPVNODE,KMPVOSET,KMPVROUT,KMPVSMH,KMPVSINT,KMPVSLOT,KMPVSTOP,KMPVLIEN
 N KMPVLLINE,KMPVLNAME,KMPVLSTATE,KMPVLRECV,KMPVLPROC,KMPVLSEND,KMPVLSENT,KMPVTEST,Y
 ; ALWAYS - verify data is not building past configured number of days - if so for any reason, delete it
 D PURGEDLY^KMPVCBG("VMCM")
 ; Quit if monitor is not turned on
 Q:$$GETVAL^KMPVCCFG("VMCM","ONOFF",8969)'="ON"
 ; Check environment
 S KMPVTEST=$$GETVAL^KMPVCCFG("VMCM","ALLOW TEST SYSTEM",8969,"I")
 I $$PROD^KMPVCCFG'="Prod",KMPVTEST'=1 Q
 S U="^"
 D GETENV^%ZOSV S KMPVNODE=$P(Y,U,3)_":"_$P($P(Y,U,4),":",2) ;  IA 10097
 ; Quit if not BE node or if Allow Test System is NO
 I $$ISBENODE^KMPVCCFG(KMPVNODE)=0&(KMPVTEST=0) Q
 ;
 S KMPVSTOP=0,KMPVCHKH=+$H
 F  D  Q:KMPVSTOP
 .I $$GETVAL^KMPVCCFG("VMCM","ONOFF",8969)'="ON" S KMPVSTOP=1 Q  ; RUN FLAG SET TO 0
 .S KMPVH=$H
 .I KMPVH>KMPVCHKH SET KMPVSTOP=1 Q
 .S KMPVSINT=$$GETVAL^KMPVCCFG("VMCM","COLLECTION INTERVAL",8969)
 .S KMPVHANG=KMPVSINT*60
 .S KMPVHTIME=$$SLOT^KMPVCCFG(KMPVH,KMPVSINT,"HOROLOG")
 .S (KMPVLIEN,KMPVLLINE,KMPVLNAME,KMPVLSTATE)=""
 .S (KMPVLRECV,KMPVLPROC,KMPVLSEND,KMPVLSENT)=0
 .F  S KMPVLIEN=$O(^HLCS(870,KMPVLIEN)) Q:KMPVLIEN=""  D
 ..I $D(^HLCS(870,KMPVLIEN,0)) D
 ...S KMPVLLINE=$G(^HLCS(870,KMPVLIEN,0))
 ...S KMPVLNAME=$P(KMPVLLINE,"^",1)_":"_$P(KMPVLLINE,"^",4)
 ...S KMPVLSTATE=$P(KMPVLLINE,"^",5)
 ...S KMPVLRECV=+$G(^HLCS(870,KMPVLIEN,"IN QUEUE BACK POINTER"))
 ...S KMPVLPROC=+$G(^HLCS(870,KMPVLIEN,"IN QUEUE FRONT POINTER"))
 ...S KMPVLSEND=+$G(^HLCS(870,KMPVLIEN,"OUT QUEUE BACK POINTER"))
 ...S KMPVLSENT=+$G(^HLCS(870,KMPVLIEN,"OUT QUEUE FRONT POINTER"))
 ...S ^KMPTMP("KMPV","VMCM","DLY",+KMPVH,KMPVNODE,KMPVLNAME,KMPVHTIME)=KMPVLRECV_"^"_KMPVLPROC_"^"_KMPVLSEND_"^"_KMPVLSENT_"^"_KMPVLSTATE
 .S ^KMPTMP("KMPV","VMCM","DLY",+KMPVH,KMPVNODE,"HLO:",KMPVHTIME)="0^"_$$HLODAILY("IN")_"^0^"_$$HLODAILY("OUT")_"^"
 .H KMPVHANG
 Q
 ;
HLODAILY(KMPVHDIR) ;
 ;
 N KMPVHTOTAL,KMPVHTODAY,KMPVHTIME,KMPVHSAP,KMPVHRAP,KMPVHTYPE
 S KMPVHTOTAL=0
 S KMPVHTODAY=$$DT^XLFDT
 S KMPVHTIME=KMPVHTODAY-.0001
 F  S KMPVHTIME=$O(^HLSTATS(KMPVHDIR,"HOURLY",KMPVHTIME)) Q:'KMPVHTIME  Q:((KMPVHTIME\1)>KMPVHTODAY)  D
 .S KMPVHSAP=""
 .F  S KMPVHSAP=$O(^HLSTATS(KMPVHDIR,"HOURLY",KMPVHTIME,KMPVHSAP)) Q:KMPVHSAP=""  D
 ..Q:KMPVHSAP="ACCEPT ACK"
 ..S KMPVHRAP=""
 ..F  S KMPVHRAP=$O(^HLSTATS(KMPVHDIR,"HOURLY",KMPVHTIME,KMPVHSAP,KMPVHRAP)) Q:KMPVHRAP=""  D
 ...S KMPVHTYPE=""
 ...F  S KMPVHTYPE=$O(^HLSTATS(KMPVHDIR,"HOURLY",KMPVHTIME,KMPVHSAP,KMPVHRAP,KMPVHTYPE)) Q:KMPVHTYPE=""  D
 ....S KMPVHTOTAL=KMPVHTOTAL+$G(^HLSTATS(KMPVHDIR,"HOURLY",KMPVHTIME,KMPVHSAP,KMPVHRAP,KMPVHTYPE))
 Q KMPVHTOTAL
 ;
SEND ; Format and send data to CPE once a day -- TASKED VIA TASKMAN
 N KMPVCFG,KMPVDATA,KMPVDOM,KMPVFMDAY,KMPVHDAY,KMPVHLAST,KMPVHOUR,KMPVHSTRT,KMPVHTODAY,KMPVHYDAY
 N KMPVKEEP,KMPVLAST,KMPVLN,KMPVNODE,KMPVRT,KMPVSINF,KMPVSITE,KMPVWD,KMPVLINK
 N %H
 K ^KMPTMP("KMPV","VMCM","TRANSMIT",$J)
 S KMPVHSTRT=$H,KMPVHTODAY=+KMPVHSTRT,KMPVSITE=$$SITE^VASITE ;  IA 10112
 S KMPVHYDAY=+$H-1
 S KMPVLAST=$$GETVAL^KMPVCCFG("VMCM","LAST START TIME",8969,"I")
 I KMPVLAST'="" D
 .S X=KMPVLAST D H^%DTC S KMPVHLAST=%H
 .I KMPVHLAST<KMPVHYDAY D CANMESS^KMPVCBG("JOBLATE","VMCM",KMPVSITE,(KMPVHYDAY-KMPVHLAST))
 ;
 S KMPVKEEP=$$GETVAL^KMPVCCFG("VMCM","DAYS TO KEEP DATA",8969)
 S KMPVSINF=$$SITEINFO^KMPVCCFG()
 S KMPVHDAY=""
 F  S KMPVHDAY=$O(^KMPTMP("KMPV","VMCM","DLY",KMPVHDAY)) Q:KMPVHDAY=""!(KMPVHDAY>KMPVHYDAY)  D
 .; IF OLDER THAN 7 DAYS AND NOT MARKED AS SENT SEND ERROR MESSAGE, KILL NODE AND GO TO NEXT DAY
 .I KMPVHDAY<(KMPVHTODAY-KMPVKEEP) D  Q
 ..D CANMESS^KMPVCBG("DELETE","VMCM",KMPVSITE,KMPVHDAY) K ^KMPTMP("KMPV","VMCM","DLY",KMPVHDAY)
 .S KMPVFMDAY=+$$HTFM^XLFDT(KMPVHDAY,1)
 .S KMPVWD=$$WORKDAY^XUWORKDY(KMPVFMDAY) ; IA#10046
 .; RETRANSMISSION FLAG: GREATER THAN ZERO MEANS MESSAGE WAS SENT TO CPE BUT ACK MESSAGE NOT YET REC'D
 .S KMPVRT=$S(+$G(^KMPTMP("KMPV","VMCM","DLY",KMPVHDAY))>0:"YES",1:"NO")
 .; IF BETWEEN 1 AND 7 DAYS OLD AND NOT TRANSMITTED SEND WARNING MESSAGE AND ATTEMPT TO TRANSMIT AGAIN
 .I KMPVHDAY<(KMPVHTODAY-1) D CANMESS^KMPVCBG("TRANWARN","VMCM",KMPVSITE,KMPVHDAY)
 .K ^KMPTMP("KMPV","VMCM","TRANSMIT",$J)
 .S KMPVLN=1
 .S ^KMPTMP("KMPV","VMCM","TRANSMIT",$J,KMPVLN)="SYSTEM ID="_KMPVSINF,KMPVLN=KMPVLN+1
 .S ^KMPTMP("KMPV","VMCM","TRANSMIT",$J,KMPVLN)="UPDATE CONFIG="_KMPVHDAY_U_KMPVWD_"^DAILY",KMPVLN=KMPVLN+1
 .S ^KMPTMP("KMPV","VMCM","TRANSMIT",$J,KMPVLN)="SYSTEM CONFIG="_$$SYSCFG^KMPVCCFG(),KMPVLN=KMPVLN+1
 .S ^KMPTMP("KMPV","VMCM","TRANSMIT",$J,KMPVLN)="MONITOR CONFIG="_$$CFGSTR^KMPVCCFG("VMCM"),KMPVLN=KMPVLN+1
 .S ^KMPTMP("KMPV","VMCM","TRANSMIT",$J,KMPVLN)="RETRANSMISSION="_KMPVRT,KMPVLN=KMPVLN+1
 .S KMPVNODE=""
 .F  S KMPVNODE=$O(^KMPTMP("KMPV","VMCM","DLY",KMPVHDAY,KMPVNODE)) Q:KMPVNODE=""  D
 ..S KMPVLINK=""
 ..F  S KMPVLINK=$O(^KMPTMP("KMPV","VMCM","DLY",KMPVHDAY,KMPVNODE,KMPVLINK)) Q:KMPVLINK=""  D
 ...S KMPVHOUR=""
 ...F  S KMPVHOUR=$O(^KMPTMP("KMPV","VMCM","DLY",KMPVHDAY,KMPVNODE,KMPVLINK,KMPVHOUR)) Q:KMPVHOUR=""  D
 ....S KMPVDATA=$G(^KMPTMP("KMPV","VMCM","DLY",KMPVHDAY,KMPVNODE,KMPVLINK,KMPVHOUR))
 ....S ^KMPTMP("KMPV","VMCM","TRANSMIT",$J,KMPVLN)="VMCM DATA="_KMPVNODE_U_KMPVLINK_U_KMPVHOUR_U_KMPVDATA,KMPVLN=KMPVLN+1
 .D TRANSMIT
 D STRSTP^KMPVCCFG("VMCM",KMPVHSTRT)
 Q
 ;
TRANSMIT ; Transmit data
 ; quit if no data to transmit.
 Q:'$D(^KMPTMP("KMPV","VMCM","TRANSMIT",$J))
 N KMPVEMAIL,X,XMSUB,XMTEXT,XMY,XMZ
 ; send data via mail message.
 S XMTEXT="^KMPTMP(""KMPV"",""VMCM"",""TRANSMIT"","_$J_","
 S XMSUB="VMCM DAILY DATA"
 S KMPVEMAIL=$$GETVAL^KMPVCCFG("VMCM","NATIONAL DATA EMAIL ADDRESS",8969) I KMPVEMAIL'="" S XMY(KMPVEMAIL)=""
 D ^XMD
 ; RECORD SUCCESS/FAILURE -- SEND MESSAGE IF FAILURE
 I +$G(XMZ)>0 D
 .S ^KMPTMP("KMPV","VMCM","DLY",KMPVHDAY)=XMZ
 E  D CANMESS^KMPVCBG("FAILTRAN","VMCM",KMPVSITE,KMPVHDAY)
 K ^KMPTMP("KMPV","VMCM","TRANSMIT",$J)
 Q
